
#version 130

attribute vec3 pos_attr;
attribute vec4 col_attr;
attribute vec2 tex_attr; // Texcoords


varying vec4 col_var;
varying vec2 tex_var;


uniform mat4 MVPMat;    // Model-View-Projection matrix
uniform mat4 TexMat;    // Texture matrix
uniform vec4 forceColor;
uniform float forceRatio;



void main()
{
	vec3 vpos = pos_attr;

	int idmod = int(mod(gl_VertexID, 4));

	float fac = max(0, min(1, idmod-1));

	vpos+=forceColor.rgb*fac;

	gl_Position = MVPMat * vec4(vpos, 1.0);
	
	tex_var=(vpos.xy - vec2(-0.5, -0.5))/512.0;

	col_var = forceColor;

}
